s         ߜ   <    #                                     SNDCSDLM                        Sorensen DLM/DCS M9                                                                                     ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]     
 
ViConstString      This instrument module provides programming support for the Sorensen DCS/DLM M9.  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
         This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

         Output State         This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

() Function Name:
This function ...         This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions/SubClasses:

() Function Name:
This function ...    W    This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.
    D    Sorensen DCS/DLM Power Supplies with an M9 Remote Programming Interface option can support up to thirty additional DCS/DLM Power Supplies with the M85 option from a single GPIB Address or RS232 Serial Port. In the following Sorensen M9 Driver Routines the ChannelName refers to the M85 Slave Address. Valid M85 Slave Addresses are two through thirty-one. Slave address zero is reserved for Group Trigger and address one is reserved for the Master M9 chassis.

This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state and clears all error and status information.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
    q    This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "GPIB::1"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
GPIB        GPIB[board]::primary address[::secondary address]
            [::INSTR]
            
The GPIB keyword is used with GPIB instruments.

The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
secondary address           none - 31
        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.
    D    This control specifies if the instrument is to be reset to its power-on settings during the initialization procedure.

Valid Range:
VI_OFF (0) - Don't Reset
VI_ON  (1) - Reset Device (Default Value)

Notes:

(1) If you do not want the instrument reset. Set this control to "Don't Reset" while initializing the instrument.
    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
         This control contains the status code returned by the function call. See Error_Message function for descriptions of returned error codes. 

     =         Resource Name                      :        ID Query                           =        Reset Device                           }    Instrument Handle                 :       Status                             
"GPIB::1"   Yes VI_ON No VI_OFF   Yes VI_ON No VI_OFF    	           	              This function configures and initiates the power supply to generate a DC voltage on the channel you specify. Programming a negative voltage value will cause the M9 rear panel user connector Polarity relay signal to close.

SCPI: SOURCE[]:VOLTAGE <voltage value>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     |    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     K    Pass the name of the channel you want to configure. Valid range is 1-31.
     x    Pass the DC voltage you want the power supply to generate.
Units: volts

Valid Range: dependent upon the model in use
    ;          Instrument Handle                         Status                            m 3 
       Channel Name                       3        Voltage                                	           "1"    0.0        This function configures and initiates the power supply to generate a DC current on the channel you specify.

SCPI: SOURCE[]:CURRENT <current value>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     |    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     6    Pass the name of the channel you want to configure.
     x    Pass the DC voltage you want the power supply to generate.
Units: volts

Valid Range: dependent upon the model in use
              Instrument Handle                 ~        Status                              3 
       Channel Name                       @ 3        Current                                	           "1"    0.0   ]    This function configures and initiates the power supply to generate a DC voltage ramp starting from the present output voltage and ending at the specified voltage in the specified time on the specified channel. Time range is from 100ms to 99sec. with 100ms resolution. Time is in seconds.

SCPI: SOURCE[]:VOLTAGE:RAMP <ending voltage value> <time>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     |    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     7    Pass the name of the channel you want to configure.

     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
     -    Ramp time in seconds.
Valid range 0.1 - 99.    #          Instrument Handle                 #        Status                            $I 3 
       Channel Name                      $ 3        Voltage                           % 3       Time                                   	           "1"    0.0    0.0   ]    This function configures and initiates the power supply to generate a DC current ramp starting from the present output voltage and ending at the specified voltage in the specified time on the specified channel. Time range is from 100ms to 99sec. with 100ms resolution. Time is in seconds.

SCPI: SOURCE[]:VOLTAGE:RAMP <ending voltage value> <time>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      6    Pass the name of the channel you want to configure.
     x    Pass the DC voltage you want the power supply to generate.
Units: amps

Valid Range: dependent upon the model in use

    '          Instrument Handle                 (}        Status                            ) 3 
       Channel Name                      )@ 3        Current                          3       Time                                   	           "1"    0.0    0.0        This function sets the output state to On (1) or Off (0). If set to OFF the Voltage and Current values will be set to zero. If set to ON the Voltage and Current will be set to their last programmed values.     7    Pass the name of the channel you want to configure.

         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     + b 6       Channel Name                      ,  4        Instrument Handle                 ,       Status                           aL        State                              "1"        	            On 1 Off 0    o    This function takes a voltage measurement of the output on the channel you specify.

SCPI: MEASURE[]:VOLTAGE?     +    Returns the measured value.

Units: volts         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      5    Pass the name of the channel you want to measure.

    . 3        Voltage Measurement               .  	        Instrument Handle                 /        Status                            0
 3 
       Channel Name                       	               	           "1"    o    This function takes a current measurement of the output on the channel you specify.

SCPI: MEASURE[]:CURRENT?     /    Returns the measured value.

Units:  amperes
         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      5    Pass the name of the channel you want to measure.

    1 3        Current Measurement               1  	        Instrument Handle                 2        Status                            3" 3 
       Channel Name                       	               	           "1"        This function returns the operationing mode of the power supply. The two modes of operation are constant voltage (mode = 0) and constant current (mode = 1). See Protection Condition Status Register for more information.     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     /        Instrument Handle                \ *       Channel Name                      5; H      status                           [C       Mode                               0    "1"    	            	               The power supply has two modes of operation: constant current and constant voltage. This function configures the power supply to shut down if the power supply switches from constant voltage mode to constant current mode. If Service Request is set ON (1) the Protection Event Status reporting mechanism will be turned on and a GPIB Service Request will be generated upon this action.     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     /        Instrument Handle                \ *       Channel Name                      8@ H      status                           Sy        Service Request                    0    "1"    	            On 1 Off 0       The power supply has two modes of operation, constant current and constant voltage. This function configures the power supply to shut down if the power supply switches from constant current mode to constant voltage mode. If Service Request is set ON (1) the Protection Event Status reporting mechanism will be turned on and a GPIB Service Request will be generated upon this action.     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     /        Instrument Handle                \ *       Channel Name                      ;G H      status                           Tx        Service Request                    0    "1"    	            On 1 Off 0        The power supply has two modes of operation, constant current and constant voltage. This function configures the power supply to operate in both modes. All Protection Event Status reporting mechanisms will be turned off.     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.    W -       Channel Name                      2        Instrument Handle                 = K      status                             "1"    0    	            a    This routine turns on/off the external user connector isolation relay on the specified channel.     7    Pass the name of the channel you want to configure.

         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     ?Q f        Channel Name                      ?          Instrument Handle                 @>       Status                           ^7        State                              "1"        	           On 1 Off 0    a    This routine turns on/off the external user connector isolation relay on the specified channel.     7    Pass the name of the channel you want to configure.

         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     |    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.    B% N C       Channel Name                     Fc        State                             Bd  >        Instrument Handle                 C 2      Status                             "1"    On 1 Off 0        	               This function configures the power supply to generate a triggered DC voltage on the channel you specify. A software trigger must be used to initiate this sequence.

SCPI: SOURCE[]:VOLTAGE:TRIG <voltage value>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      7    Pass the name of the channel you want to configure.

     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
    Ei          Instrument Handle                 F        Status                            F 3 
       Channel Name                      F 3        Voltage                                	           "1"    0.0        This function configures the power supply to generate a triggered DC current on the channel you specify. A software trigger must be used to initiate this sequence.

SCPI: SOURCE[]:CURRENT:TRIG <current value>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      7    Pass the name of the channel you want to configure.

     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
    I&          Instrument Handle                 I        Status                            JY 3 
       Channel Name                      J 3        Current                                	           "1"    0.0   K    This function configures the power supply to generate a triggered DC voltage ramp starting at the present output voltage and ending at the specified voltage in the specified time on the specified channel. Time is in seconds. See Send Software Trigger for more information.

SCPI: SOURCE[]:VOLTAGE:RAMP:TRIG <voltage value> <time>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     |    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     6    Pass the name of the channel you want to configure.
     w    Pass the DC voltage you want the power supply to generate.
Units: volts
Valid Range: dependent upon the model in use
     .    Ramp time in seconds.
Range is 0.1 - 99 sec.    M\          Instrument Handle                 N
        Status                            N 3 
       Channel Name                      N 3        Voltage                           OK 2       Time                                   	           "1"    0.0    0.0   K    This function configures the power supply to generate a triggered DC current ramp starting at the present output current and ending at the specified current in the specified time on the specified channel. Time is in seconds. See Send Software Trigger for more information.

SCPI: SOURCE[]:CURRENT:RAMP:TRIG <current value> <time>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     6    Pass the name of the channel you want to configure.
     v    Pass the DC current you want the power supply to generate.
Units: amps
Valid Range: dependent upon the model in use
        Pass the DC voltage you want the power supply to generate.  The driver sets the M9_ATTR_DC_VOLTAGE attribute to this value.

Units: volts

Valid Range: dependent upon the model in use

The following lists the maximum voltage you can configure on each model.  The minimum voltage you can configure is 0.0.  Voltage capabilities are shown in the following format:
model: channel 1 voltage, channel 2 voltage, ...

HP6621A:  20.2,  20.2
HP6622A:  50.5,  50.5
HP6623A:  20.2,  20.2,  50.5
HP6624A:  20.2,  20.2,  50.5,  50.5
HP6625A:  50.5,  50.5
HP6626A:  50.5,  50.5,  50.5,  50.5
HP6627A:  50.5,  50.5,  50.5,  50.5
HP6628A:  50.5,  50.5
HP6629A:  50.5,  50.5,  50.5,  50.5

Default Value: 0.0
    R          Instrument Handle                       Status                            R 3 
       Channel Name                      R 3        Current                           Sl 2       Time                                   	           "1"    0.0    0.0        This function sets the Over Voltage Protection limit on the channel you specify. If the output of the instrument exceeds this value the instrument will shutdown and must be Reset to continue.

SCPI: SOURCE[]:VOLTAGE:PROTECTION <ovp value>
         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      7    Pass the name of the channel you want to configure.

         Pass the DC over voltage value you want the power supply shutdown at.
Units: volts
Valid Range: dependent upon the model in use

    XR          Instrument Handle                 Y         Status                            Y 3 
       Channel Name                      Y 3        Overvoltage Protection                 	           "1"    0.0        This function sets the soft voltage and current programming limits for the selected channel.

SCPI: SOURCE[]:VOLTAGE:LIMIT <voltage value>
      SOURCE[]:CURRENT:LIMIT <current value>     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    \       Status                            \          Instrument Handle                U        Channel Name                     T        Volltage Limit                   U       Current Limit                      	               "1"    0.0    0.0       This function sets the power on output values for voltage, current, and over voltage protection on the selected channel.

SCPI: CALIBRATE[]:INITIAL:VOLTAGE <voltage value>
      CALIBRATE[]:INITIAL:CURRENT <current value>
      CALIBRATE[]:INITIAL:VOLTAGE:PROTECTION <ovp value>     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    _       Status                            `          Instrument Handle                U        Channel Name                     T        Voltage                          U       Current                                 OVP                                	               "1"    0.0    0.0    0.0        This routine configures the foldback mode for the selected channel. The three mode are: 0 = off, 1 = Constant Volatge, 2 = Constant Current. Configuring the foldback mode for Constant Voltage or Constant Current will cause the power supply to shut down if the other mode becomes active.         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.    e 1       Channel Name                     bi       Mode                              cH  0        Instrument Handle                 c h      Status                             "1"    0        	          b    This routine configures the Protection Event Status Enable Register which causes the instrument to shut down if Constant Current, Constant Voltage, Foldback Modes or other conditions are enabled. Along with this register the Service Request Enable Register must be programmed to generate GPIB Service Requests.

SCPI: STATUS[]:PROTECTION:ENABLE <value>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.    K        Channel Name                      f          Instrument Handle                 g N      Status                           HO        Protection Event Enable            "1"        	           0        This routine configures the Standard Event Status Enable Register. Along with this register the Service Request Enable Register must be programmed to generate GPIB Service Requests.

SCPI: *ESE[] <value>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.    K        Channel Name                      i          Instrument Handle                 j{ N      Status                           HO        Standard Event Enable              "1"        	           0   n    This routine sets the Service Request Enable Register which is used to enable GPIB Service Requests when a enabled protection event or standard event has occured. This register along with the Protection Event Status Enable Register or the Standard Event Status Enable Register must be programmed to enable generation of GPIB Service Requests.

SCPI: *SRE[] <value>         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.    @        Channel Name                      mf          Instrument Handle                 n >      Status                           :B        Service Request Enable             "1"        	           0    g    This function returns the programmed voltage value on the channel you specify.

SCPI: SOURCE[]:VOLT?
     -    Returns the measured value.

Units:  volts
         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      5    Pass the name of the channel you want to measure.

    o 3        Programmed Voltage                p-  	        Instrument Handle                 p        Status                            q` 3 
       Channel Name                       	               	           "1"    j    This function returns the programmed current value on the channel you specify.

SCPI: SOURCE[]:CURRENT?
     /    Returns the measured value.

Units:  amperes
         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      5    Pass the name of the channel you want to measure.

    s 3        Programmed Current                s=  	        Instrument Handle                 s        Status                            tp 3 
       Channel Name                       	               	           "1"        This function returns the programmed overvoltage protection value on the channel you specify.

SCPI: SOURCE[]:VOLTAGE:PROTECTION?     /    Returns the programmed value.

Units:  volts
         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      4    Pass the name of the channel you want to measure.
    v/ 3        Programmed OVP                    vf  	        Instrument Handle                 w        Status                            w 3 
       Channel Name                       	               	           "1"    :    This function gets the output state - On (1) or Off (0).     6    Pass the name of the channel you want to configure.
         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     y b 6       Channel Name                      yL  4        Instrument Handle                 y       Status                           _       State                              "1"        	            	            C    This function gets the isolation relay state - On (1) or Off (0).     6    Pass the name of the channel you want to configure.
         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     { b 6       Channel Name                      {  4        Instrument Handle                 |       Status                           _       State                              "1"        	            	            ?    This function gets the sense relay state - On (1) or Off (0).     7    Pass the name of the channel you want to configure.

         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
    ~p b 6       Channel Name                      ~  4        Instrument Handle                      Status                           _       State                              "1"        	            	                This function recalls the soft voltage and current programming limits for the selected channel.

SCPI: SOURCE[]:VOLTAGE:LIMIT?
      SOURCE[]:CURRENT:LIMIT?         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      5    Pass the name of the channel you want to measure.

      	        Instrument Handle                  o      Status                            - 3 
       Channel Name                     3        Voltage Limit                    1r       Current Limit                          	           "1"    	           	               This function recalls the power on output voltage, current, and ovp values for the selected channel.

SCPI: CALIBRATE[]:INITIAL:VOLTAGE?
      CALIBRATE[]:INITIAL:CURRENT?
      CALIBRATE[]:INITIAL:VOLTAGE:PROTECTION?         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.      5    Pass the name of the channel you want to measure.

              Instrument Handle                 3 o      Status                             3 
       Channel Name                     3        Voltage                          1r       Current                          r       OVP                                    	           "1"    	           	           	          z    This function sends a software trigger to the channel you specify. Setting the channel to zero will trigger all power supplies that have been previously configured for triggered voltage and/or current outputs. The trigger types are as follows:

1 = Voltage
2 = Current
3 = Both Voltage and Current
4 = Voltage or Current Ramp

SCPI: TRIGGER[]:TYPE <value>
      TRIGGER[]:RAMP     |    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.    8        Instrument Handle                  <      Status                           N 8       Channel Name                     N>       Trigger Type                       0    	           "1"    1        This function clears all previously configured voltage and current triggers for the specified channel.

SCPI: TRIGGER[]:ABORT      }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.     '        Instrument Handle                         Status                           E #       Channel Name                       0    	           "1"        This function reads the status byte from the instrument and creates a string that indicates which bits are active.

SCPI: *STB[]?

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     U,        Status Byte                         n  ,    Status Message                     (      Status                            ?  5        Instrument Handle                Y <       Channel Name                       	            	            	               "1"        This function reads the standard event status register from the instrument and creates a string that indicates which bits are active.

SCPI: *ESR[]?

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     ?Y        Standard Event Status Register      t  ,    Status Message                     >      Status                            ?  5        Instrument Handle                = <       Channel Name                       	            	            	               "1"        This function reads the event status enable register from the instrument and creates a string that indicates which bits are active.

SCPI: *ESE[]?

     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   ?Y        Standard Event  Enable Register   t  ,    Status Message                     >      Status                            9  5        Instrument Handle                = <       Channel Name                       	            	            	               "1"        This function reads the protection event status reister from the instrument and creates a string that indicates which bits are active.

SCPI: STATUS[]:PROTECTION:EVENT?

         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   An        Protection Event Register           ,    Status Message                  g      Status                             +        Instrument Handle                > 4       Channel Name                       	            	            	               "1"        This function reads the protection event status enable register from the instrument and creates a string that indicates which bits are active.

SCPI: STATUS[]:PROTECTION:ENABLE?

     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   An        Prot. Event Enable Register         ,    Status Message                    Xg      Status                             +        Instrument Handle                > 4       Channel Name                       	            	            	               "1"       This function reads the protection condition status reister from the instrument and creates a string that indicates which bits are active. Use this routine to determine the operating mode (voltage or current) of the power supply.

SCPI: STATUS[]:PROTECTION:CONDITION?

     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   An        Protection Condition Register     ~  ,    Status Message                    g      Status                            P +        Instrument Handle                > 4       Channel Name                       	            	            	               "1"        This function reads the service request enable reister from the instrument and creates a string that indicates which bits are active.

SCPI:*SRE[]?

     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   An        Service Req. Enable Register      ~  ,    Status Message                    g      Status                            K +        Instrument Handle                > 4       Channel Name                       	            	            	               "1"        This function resets the instrument to its Power On state and clears all error and status reporting data structures on the selected channel.

SCPI: *RST[]
      *CLS[]

     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     G      Status                            Z  *        Instrument Handle                E /       Channel Name                       	               "1"    n    This function clears all error and status reporting data structures on the selected channel.

SCPI: *CLS[]

     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    % G      Status                              *        Instrument Handle                E /       Channel Name                       	               "1"    l    This function reads an error code and error string from the instrument's error queue.

SCPI: SYSTEM:ERROR?     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    s = D        Error Code                         ?   ,    Error Message                     w ?      Status                              6        Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     (    Reports the status of this operation.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL    * =         Status Code                        =       Message                           J
      Status                            z 5        Instrument Handle                  0    	            	           VI_NULL    ~    This function returns the Manufacturer, Model, Serial Number and firmware revision numbers of the instrument.

SCPI: *IDN[]?         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     =       *IDN? Respone                     ,       Status                              1        Instrument Handle                < 1       Channel Name                       	            	               "1"    ^    This function returns the revision numbers of the instrument driver and instrument firmware.         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     C/       Instrument Driver Revision        ; .       Firmware Revision                  ]      Status                            G  3        Instrument Handle                B 7       Channel Name                       	            	            	               "1"        This function recalls the instrument's maximum voltage and current rating for the selected channel.

SCPI: CALIBRATE[]:MODEL:VOLTAGE?
      CALIBRATE[]:MODEL:CURRENT?         The ViSession handle that you obtain from the M9_init or M9_InitWithOptions function.  The handle identifies a particular instrument session.

Default Value:  None
     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.           Pass the name of the channel.
      	        Instrument Handle                 | o      Status                             3 
       Channel Name                     3        Model Voltage                    1r       Model Current                          	           "1"    	           	               This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.     }    Reports the status of this operation.

To obtain a text description of the status code call the M9_error_message function.          This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     pD      Status                             r `        Instrument Handle                  	                                    K.        init                                                                                                                                             ,  @             K.        GenerateDCVolt                                                                                                                                   2                K.        GenerateDCCurr                                                                                                                                   !  %<             .        GenerateDCVRamp                                                                                                                                  &j  )             .        GenerateDCCRamp                                                                                                                                  *  -7             K.        OutState                                                                                                                                         .0  0J             .        MeasureDCVolt                                                                                                                                    1A  3_             .        MeasureDCCurr                                                                                                                                    4V  5             K.        QueryMode                                                                                                                                        6  8             K.        VoltMode                                                                                                                                         9  ;             K.        CurrMode                                                                                                                                         <  >1             K.        NormalMode                                                                                                                                       >  @             K.        IsolationRelay                                                                                                                                   A  C             K.        SenseRelay                                                                                                                                       D  GZ             K.        ConfigDCVolt                                                                                                                                     HL  K             K.        ConfigDCCurr                                                                                                                                     L	  O             K.        ConfigDCVRamp                                                                                                                                    P  V+             K.        ConfigDCCRamp                                                                                                                                    WY  ZO             K.        ConfigOVP                                                                                                                                        [A  ]5             K.        ConfigSoftLimits                                                                                                                                 ^c  `             K.        ConfigPowerOn                                                                                                                                    b   d{             K.        ConfigFoldback                                                                                                                                   ek  h             K.        ConfigProtEventEnable                                                                                                                            h  k              K.        ConfigStandEventEnable                                                                                                                           k  n             K.        ConfigSerReqEnable                                                                                                                               o  q             .        OutputVoltQuery                                                                                                                                  r  t             .        OutputCurrQuery                                                                                                                                  u  w             .        OutputOVPQuery                                                                                                                                   x  z             K.        OutStateQuery                                                                                                                                    {v  }2             K.        IsoRelayQuery                                                                                                                                    ~)  ]             K.        SenseRelayQuery                                                                                                                                  T  j             .        SoftLimitsQuery                                                                                                                                                 .        PowerOnQuery                                                                                                                                     n  t             K.        SendSWTrigger                                                                                                                                    e  r             K.        AbortTrigger                                                                                                                                     )               K.        StatusByteQuery                                                                                                                                                 K.        StandEventQuery                                                                                                                                                 K.        StandEventEnableQuery                                                                                                                              c             K.        ProtEventQuery                                                                                                                                     |             K.        ProtEventEnableQuery                                                                                                                                            K.        ProtCondQuery                                                                                                                                    '               K.        ServiceReqEnableQuery                                                                                                                            "               K.        reset                                                                                                                                              I             K.        clear                                                                                                                                                           K.        errorQuery                                                                                                                                                      K.        errorMessage                                                                                                                                       P             K.        idQuery                                                                                                                                          G               E.        revisionQuery                                                                                                                                      )             .        ModelQuery                                                                                                                                       a  2             K.        close                                                                                                                                                                                                                               Initialize                                                                          Application Functions                                                             Generate Output                                                                      Generate DC Voltage                                                                  Generate DC Current                                                                  Generate DC Voltage Ramp                                                             Generate DC Current Ramp                                                            Output State                                                                         Output State On/Off                                                               Measure Output                                                                       Measure DC Voltage                                                                   Measure DC Current                                                                Operating Mode                                                                       Query Output Mode                                                                    Constant Voltage Mode                                                                Constant Current Mode                                                                Normal Mode                                                                       External User                                                                        Isolation Relay                                                                      Sense Relay                                                                         Configuration Functions                                                              Configure DC Voltage                                                                 Configure DC Current                                                                 Configure DC Voltage Ramp                                                            Configure DC Current Ramp                                                            Configure OVP                                                                        Configure Soft Limits                                                                Configure Power On                                                                   Configure Foldback                                                                   Configure Protect. Event Enable                                                      Configure Standard Event Enable                                                      Configure Service Req. Enable                                                        Output Voltage Query                                                                 Output Current Query                                                                 Output OVP Query                                                                     Output State Query                                                                   Isolation Relay Query                                                                Sense Relay Query                                                                    Soft Limits Query                                                                    Power On Query                                                                      Action/Status Functions                                                              Send Software Trigger                                                                Abort Trigger                                                                        Status Byte Query                                                                    Standard Event Query                                                                 Standard Event Enable Query                                                          Protection Event Query                                                               Protection Event Enable Query                                                        Protection Condition Query                                                           Sevice Req. Enable Query                                                            dUtility Functions                                                                    Reset                                                                                Clear                                                                                Error Query                                                                          Error Message                                                                        Id Query                                                                             Revision Query                                                                       Model Query                                                                          Close                                                                           